
print("Loading Caves Bag Prefab...")

--[[
local assets=
{
    Asset("ANIM", "anim/maxwells_chest.zip"),


    Asset("IMAGE", "images/ui_chest_5x16.tex"),
    Asset("ATLAS", "images/ui_chest_5x16.xml"),
    Asset("IMAGE", "images/inventoryimages/maxwellschest.tex"),
    Asset("ATLAS", "images/inventoryimages/maxwellschest.xml"),
}
--]]

local function OnEquip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_body", "swap_cavepac_sack", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "swap_cavepac_sack", "swap_body")
	owner.components.inventory.overflow = inst
	inst.components.container:Open(owner)
end

local function OnUnequip(inst, owner) 
	owner.AnimState:ClearOverrideSymbol("swap_body")
	owner.AnimState:ClearOverrideSymbol("backpack")
	owner.components.inventory.overflow = nil
	inst.components.container:Close(owner)
end

local function OnOpen(inst)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/backpack_open", "open")
end

local function OnClose(inst)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/backpack_close", "open")
end

local slotpos = {}
for y = 0, 7 do

	table.insert(slotpos, Vector3(3  -75, -y*75 + 265, 0))	--New 3rd col
	table.insert(slotpos, Vector3(3     , -y*75 + 265 ,0))	--2nd col
	table.insert(slotpos, Vector3(3  +75, -y*75 + 265 ,0))	--1st col at screen edge
	
end


local function fn(Sim)

	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("backpack1")
	inst.AnimState:SetBuild("swap_cavepac_sack") 

	inst.AnimState:PlayAnimation("anim")
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "caves_bag"
	--fuck me!
	inst.components.inventoryitem.atlasname = "images/inventoryimages/caves_bag.xml"
	--fuck me!
	inst.components.inventoryitem.cangoincontainer = false
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/backpack"
	
    inst:AddComponent("equippable")
	--Add support for Backpack Mod by Fontonkonbonmon
	if EQUIPSLOTS["BACK"] then
		inst.components.equippable.equipslot = EQUIPSLOTS.BACK
	else
		inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	end
	-- / Add support for Backpack Mod by Fontonkonbonmon
	inst.components.equippable:SetOnEquip( OnEquip )
	inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos)
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetpos = Vector3(625,-75,0)	--backpack screen position (middle number is up and down)
    inst.components.container.widgetanimbank = "ui_backpack_2x4"
    inst.components.container.widgetanimbuild = "ui_backpack_2x4"
	
	inst.components.container.widgetbgimage = "ui_caves_bag_7x3.tex"
	inst.components.container.widgetbgatlas = "images/inventoryimages/ui_caves_bag_7x3.xml"
	--inst.components.container.widgetbgimage = "images/inventoryimages/ui_caves_bag_7x3.tex"
	inst.components.container.widgetbgimagepos = Vector3(-65, -185, 0)
    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
	
	return inst
end

return Prefab( "common/inventory/caves_bag", fn, assets)
